/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import com.comphenix.protocol.wrappers.nbt.TileEntityAccessor;
import com.comphenix.protocol.wrappers.nbt.WrappedCompound;
import com.comphenix.protocol.wrappers.nbt.WrappedElement;
import com.comphenix.protocol.wrappers.nbt.WrappedList;
import com.comphenix.protocol.wrappers.nbt.io.NbtBinarySerializer;
import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;

public class NbtFactory {
    private static final Map<NbtType, Constructor<?>> CONSTRUCTORS = new ConcurrentHashMap();
    private static Method methodCreateTag;
    private static boolean methodCreateWithName;
    private static StructureModifier<Object> itemStackModifier;
    private static Method getTagType;

    public static NbtCompound asCompound(NbtBase<?> tag) {
        if (tag instanceof NbtCompound) {
            return (NbtCompound)tag;
        }
        if (tag != null) {
            throw new UnsupportedOperationException("Cannot cast a " + String.valueOf(tag.getClass()) + "( " + String.valueOf((Object)tag.getType()) + ") to TAG_COMPUND.");
        }
        throw new IllegalArgumentException("Tag cannot be NULL.");
    }

    public static NbtList<?> asList(NbtBase<?> tag) {
        if (tag instanceof NbtList) {
            return (NbtList)tag;
        }
        if (tag != null) {
            throw new UnsupportedOperationException("Cannot cast a " + String.valueOf(tag.getClass()) + "( " + String.valueOf((Object)tag.getType()) + ") to TAG_LIST.");
        }
        throw new IllegalArgumentException("Tag cannot be NULL.");
    }

    public static <T> NbtWrapper<T> fromBase(NbtBase<T> base) {
        if (base instanceof NbtWrapper) {
            return (NbtWrapper)base;
        }
        if (base.getType() == NbtType.TAG_COMPOUND) {
            WrappedCompound copy = WrappedCompound.fromName(base.getName());
            T value = base.getValue();
            copy.setValue((Map)value);
            return copy;
        }
        if (base.getType() == NbtType.TAG_LIST) {
            NbtList copy = WrappedList.fromName(base.getName());
            copy.setValue((List)base.getValue());
            return (NbtWrapper)((Object)copy);
        }
        NbtWrapper<T> copy = NbtFactory.ofWrapper(base.getType(), base.getName());
        copy.setValue(base.getValue());
        return copy;
    }

    public static void setItemTag(ItemStack stack, NbtCompound compound) {
        NbtFactory.checkItemStack(stack);
        StructureModifier<NbtBase<?>> modifier = NbtFactory.getStackModifier(stack);
        modifier.write(0, compound);
    }

    public static NbtWrapper<?> fromItemTag(ItemStack stack) {
        NbtFactory.checkItemStack(stack);
        StructureModifier<NbtBase<?>> modifier = NbtFactory.getStackModifier(stack);
        NbtCompound result = modifier.read(0);
        if (result == null) {
            result = NbtFactory.ofCompound("tag");
            modifier.write(0, result);
        }
        return NbtFactory.fromBase(result);
    }

    public static Optional<NbtWrapper<?>> fromItemOptional(ItemStack stack) {
        NbtFactory.checkItemStack(stack);
        StructureModifier<NbtBase<?>> modifier = NbtFactory.getStackModifier(stack);
        NbtBase<?> result = modifier.read(0);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(NbtFactory.fromBase(result));
    }

    public static NbtCompound fromFile(String file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file cannot be NULL");
        try (FileInputStream stream = new FileInputStream(file);){
            NbtCompound nbtCompound;
            try (DataInputStream input = new DataInputStream(new GZIPInputStream(stream));){
                nbtCompound = NbtBinarySerializer.DEFAULT.deserializeCompound(input);
            }
            return nbtCompound;
        }
    }

    public static void toFile(NbtCompound compound, String file) throws IOException {
        Preconditions.checkNotNull((Object)compound, (Object)"compound cannot be NULL");
        Preconditions.checkNotNull((Object)file, (Object)"file cannot be NULL");
        try (FileOutputStream stream = new FileOutputStream(file);
             DataOutputStream output = new DataOutputStream(new GZIPOutputStream(stream));){
            NbtBinarySerializer.DEFAULT.serialize(compound, output);
        }
    }

    public static NbtCompound readBlockState(Block block) {
        BlockState state = block.getState();
        TileEntityAccessor<BlockState> accessor = TileEntityAccessor.getAccessor(state);
        return accessor != null ? accessor.readBlockState(state) : null;
    }

    public static void writeBlockState(Block target, NbtCompound blockState) {
        BlockState state = target.getState();
        TileEntityAccessor<BlockState> accessor = TileEntityAccessor.getAccessor(state);
        if (accessor == null) {
            throw new IllegalArgumentException("Unable to find tile entity in " + String.valueOf(target));
        }
        accessor.writeBlockState(state, blockState);
    }

    private static void checkItemStack(ItemStack stack) {
        if (stack == null) {
            throw new IllegalArgumentException("Stack cannot be NULL.");
        }
        if (!MinecraftReflection.isCraftItemStack(stack)) {
            throw new IllegalArgumentException("Stack must be a CraftItemStack.");
        }
        if (stack.getType() == Material.AIR) {
            throw new IllegalArgumentException("ItemStacks representing air cannot store NMS information.");
        }
    }

    private static StructureModifier<NbtBase<?>> getStackModifier(ItemStack stack) {
        Object nmsStack = MinecraftReflection.getMinecraftItemStack(stack);
        if (itemStackModifier == null) {
            itemStackModifier = new StructureModifier(nmsStack.getClass(), Object.class, false);
        }
        return itemStackModifier.withTarget(nmsStack).withType(MinecraftReflection.getNBTBaseClass(), BukkitConverters.getNbtConverter());
    }

    @Deprecated
    public static <T> NbtWrapper<T> fromNMS(Object handle) {
        WrappedElement partial = new WrappedElement(handle);
        if (partial.getType() == NbtType.TAG_COMPOUND) {
            return new WrappedCompound(handle);
        }
        if (partial.getType() == NbtType.TAG_LIST) {
            return new WrappedList(handle);
        }
        return partial;
    }

    public static <T> NbtWrapper<T> fromNMS(Object handle, String name) {
        WrappedElement partial = new WrappedElement(handle, name);
        if (partial.getType() == NbtType.TAG_COMPOUND) {
            return new WrappedCompound(handle, name);
        }
        if (partial.getType() == NbtType.TAG_LIST) {
            return new WrappedList(handle, name);
        }
        return partial;
    }

    public static NbtCompound fromNMSCompound(@Nonnull Object handle) {
        if (handle == null) {
            throw new IllegalArgumentException("handle cannot be NULL.");
        }
        return (NbtCompound)((Object)NbtFactory.fromNMS(handle));
    }

    public static NbtBase<String> of(String name, String value) {
        return NbtFactory.ofWrapper(NbtType.TAG_STRING, name, value);
    }

    public static NbtBase<Byte> of(String name, byte value) {
        return NbtFactory.ofWrapper(NbtType.TAG_BYTE, name, Byte.valueOf(value));
    }

    public static NbtBase<Short> of(String name, short value) {
        return NbtFactory.ofWrapper(NbtType.TAG_SHORT, name, Short.valueOf(value));
    }

    public static NbtBase<Integer> of(String name, int value) {
        return NbtFactory.ofWrapper(NbtType.TAG_INT, name, Integer.valueOf(value));
    }

    public static NbtBase<Long> of(String name, long value) {
        return NbtFactory.ofWrapper(NbtType.TAG_LONG, name, Long.valueOf(value));
    }

    public static NbtBase<Float> of(String name, float value) {
        return NbtFactory.ofWrapper(NbtType.TAG_FLOAT, name, Float.valueOf(value));
    }

    public static NbtBase<Double> of(String name, double value) {
        return NbtFactory.ofWrapper(NbtType.TAG_DOUBLE, name, Double.valueOf(value));
    }

    public static NbtBase<byte[]> of(String name, byte[] value) {
        return NbtFactory.ofWrapper(NbtType.TAG_BYTE_ARRAY, name, value);
    }

    public static NbtBase<int[]> of(String name, int[] value) {
        return NbtFactory.ofWrapper(NbtType.TAG_INT_ARRAY, name, value);
    }

    public static NbtCompound ofCompound(String name, Collection<? extends NbtBase<?>> list) {
        return WrappedCompound.fromList(name, list);
    }

    public static NbtCompound ofCompound(String name) {
        return WrappedCompound.fromName(name);
    }

    @SafeVarargs
    public static <T> NbtList<T> ofList(String name, T ... elements) {
        return WrappedList.fromArray(name, elements);
    }

    public static <T> NbtList<T> ofList(String name, Collection<? extends T> elements) {
        return WrappedList.fromList(name, elements);
    }

    public static <T> NbtWrapper<T> ofWrapper(NbtType type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be NULL.");
        }
        if (type == NbtType.TAG_END) {
            throw new IllegalArgumentException("Cannot create a TAG_END.");
        }
        if (MinecraftVersion.BEE_UPDATE.atOrAbove()) {
            return NbtFactory.createTagNew(type, name, new Object[0]);
        }
        if (methodCreateTag == null) {
            Class<?> base = MinecraftReflection.getNBTBaseClass();
            try {
                methodCreateTag = NbtFactory.findCreateMethod(base, Byte.TYPE, String.class);
                methodCreateWithName = true;
            }
            catch (Exception e) {
                methodCreateTag = NbtFactory.findCreateMethod(base, Byte.TYPE);
                methodCreateWithName = false;
            }
        }
        try {
            if (methodCreateWithName) {
                return NbtFactory.createTagWithName(type, name);
            }
            return NbtFactory.createTagSetName(type, name);
        }
        catch (Exception e) {
            throw new FieldAccessException(String.format("Cannot create NBT element %s (type: %s)", new Object[]{name, type}), e);
        }
    }

    private static Method findCreateMethod(Class<?> base, Class<?> ... params) {
        Method method = FuzzyReflection.fromClass(base, true).getMethodByReturnTypeAndParameters("createTag", base, params);
        method.setAccessible(true);
        return method;
    }

    private static <T> NbtWrapper<T> createTagWithName(NbtType type, String name) throws Exception {
        Object handle = methodCreateTag.invoke(null, (byte)type.getRawID(), name);
        if (type == NbtType.TAG_COMPOUND) {
            return new WrappedCompound(handle);
        }
        if (type == NbtType.TAG_LIST) {
            return new WrappedList(handle);
        }
        return new WrappedElement(handle);
    }

    private static <T> NbtWrapper<T> createTagSetName(NbtType type, String name) throws Exception {
        Object handle = methodCreateTag.invoke(null, (byte)type.getRawID());
        if (type == NbtType.TAG_COMPOUND) {
            return new WrappedCompound(handle, name);
        }
        if (type == NbtType.TAG_LIST) {
            return new WrappedList(handle, name);
        }
        return new WrappedElement(handle, name);
    }

    @SafeVarargs
    private static <T> NbtWrapper<T> createTagNew(NbtType type, String name, T ... values) {
        Object handle;
        if (type == NbtType.TAG_END) {
            throw new IllegalArgumentException("Can't create END tags");
        }
        int nbtId = type.getRawID();
        Class<?> valueType = type.getValueType();
        Constructor<?> constructor = CONSTRUCTORS.get((Object)type);
        if (constructor == null) {
            Class<?> nbtClass;
            FuzzyReflection fuzzy;
            if (getTagType == null) {
                Class<?> tagTypes = MinecraftReflection.getNbtTagTypes();
                fuzzy = FuzzyReflection.fromClass(tagTypes, false);
                getTagType = fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterExactType(Integer.TYPE).build());
            }
            try {
                nbtClass = getTagType.invoke(null, nbtId).getClass().getEnclosingClass();
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to determine NBT class from " + String.valueOf((Object)type), ex);
            }
            try {
                fuzzy = FuzzyReflection.fromClass(nbtClass, true);
                constructor = type == NbtType.TAG_LIST ? fuzzy.getConstructor(FuzzyMethodContract.newBuilder().parameterCount(0).build()) : fuzzy.getConstructor(FuzzyMethodContract.newBuilder().parameterCount(1).parameterSuperOf(valueType).build());
                constructor.setAccessible(true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to find NBT constructor in " + String.valueOf(nbtClass), ex);
            }
            CONSTRUCTORS.put(type, constructor);
        }
        Object value = values.length > 0 ? values[0] : DefaultInstances.DEFAULT.getDefault(valueType);
        try {
            handle = type == NbtType.TAG_LIST ? constructor.newInstance(new Object[0]) : constructor.newInstance(value);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create NBT wrapper for " + String.valueOf((Object)type), ex);
        }
        if (type == NbtType.TAG_COMPOUND) {
            return new WrappedCompound(handle, name);
        }
        if (type == NbtType.TAG_LIST) {
            return new WrappedList(handle, name);
        }
        return new WrappedElement(handle, name);
    }

    public static <T> NbtWrapper<T> ofWrapper(NbtType type, String name, T value) {
        if (MinecraftVersion.BEE_UPDATE.atOrAbove()) {
            return NbtFactory.createTagNew(type, name, value);
        }
        NbtWrapper<T> created = NbtFactory.ofWrapper(type, name);
        created.setValue(value);
        return created;
    }

    public static <T> NbtWrapper<T> ofWrapper(Class<?> type, String name, T value) {
        return NbtFactory.ofWrapper(NbtType.getTypeFromClass(type), name, value);
    }
}

